<?php
require 'auth.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$currentUser = $_SESSION['user'] ?? '';

$logFile = __DIR__ . '/logs/emails.json';
$allEmails = file_exists($logFile)
    ? json_decode(file_get_contents($logFile), true)
    : [];

// 🔐 FILTER EMAILS
$emails = [];
foreach ($allEmails as $email) {
    if ($currentUser === 'admin' || $email['user'] === $currentUser) {
        $emails[] = $email;
    }
}

// ==============================
// PAGINATION SETUP
// ==============================
$perPage = 10; // 👈 change number of emails per page here
$totalEmails = count($emails);
$totalPages = max(1, ceil($totalEmails / $perPage));

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, min($page, $totalPages));

$offset = ($page - 1) * $perPage;

// newest first
$emails = array_reverse($emails);

// slice emails for current page
$emails = array_slice($emails, $offset, $perPage);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Sent Emails</title>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f2f2f2;
    margin: 0;
}
.container {
    max-width: 1100px;
    margin: auto;
    background: #ffffff;
    padding: 15px;
}
.top-bar {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    gap: 10px;
    margin-bottom: 15px;
}
.top-bar a {
    text-decoration: none;
    color: #0066ff;
    font-weight: bold;
}
.email-card {
    background: #fafafa;
    border-radius: 6px;
    padding: 12px;
    margin-bottom: 12px;
}
.email-card strong {
    display: block;
    margin-top: 4px;
}
.toggle {
    margin-top: 8px;
    display: inline-block;
    color: #0066ff;
    cursor: pointer;
}
.email-body {
    display: none;
    background: #ffffff;
    padding: 10px;
    margin-top: 10px;
    border-radius: 4px;
    border: 1px solid #ddd;
}
.attachments {
    margin-top: 10px;
    font-size: 14px;
}
.attachments ul {
    padding-left: 18px;
    margin: 5px 0 0;
}
.edit-btn {
    display: inline-block;
    margin-top: 8px;
    padding: 6px 10px;
    background: #2563eb;
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
    font-size: 13px;
}
.delete-btn {
    display: inline-block;
    margin-top: 8px;
    margin-left: 6px;
    padding: 6px 10px;
    background: #dc3545;
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
    font-size: 13px;
}

/* Desktop table */
table {
    width: 100%;
    border-collapse: collapse;
    display: none;
}
th, td {
    padding: 10px;
    border-bottom: 1px solid #ddd;
}
th {
    background: #f7f7f7;
}

/* Desktop breakpoint */
@media (min-width: 768px) {
    table {
        display: table;
    }
    .email-card {
        display: none;
    }
}
</style>

<script>
function toggleBody(id) {
    const el = document.getElementById(id);
    el.style.display = el.style.display === 'none' ? 'block' : 'none';
}
</script>
</head>
<body>

<div class="container">

<div class="top-bar">
    <div>
        👤 <?= htmlspecialchars($currentUser) ?>
        <?php if ($currentUser === 'admin'): ?>
            <span style="color:#28a745;">(admin – all emails)</span>
        <?php endif; ?>
    </div>
    <div>
        <a href="composer.php">Compose</a> |
        <a href="logout.php">Logout</a>
    </div>
</div>

<h2>Sent Emails</h2>

<?php if (empty($emails)): ?>
    <p>No sent emails to display.</p>
<?php endif; ?>

<!-- MOBILE CARDS -->
<?php foreach ($emails as $i => $email): ?>
<div class="email-card">
    <strong>Date:</strong> <?= htmlspecialchars($email['date']) ?>
    <strong>User:</strong> <?= htmlspecialchars($email['user']) ?>
    <strong>From:</strong> <?= htmlspecialchars($email['from']) ?>
    <strong>To:</strong> <?= htmlspecialchars($email['to']) ?>
    <strong>Subject:</strong> <?= htmlspecialchars($email['subject']) ?>

    <span class="toggle" onclick="toggleBody('m<?= $i ?>')">View Email</span>

    <div id="m<?= $i ?>" class="email-body">
        <?= $email['body'] ?>

        <?php if (!empty($email['attachments'])): ?>
            <div class="attachments">
                <strong>Attachments:</strong>
                <ul>
                    <?php foreach ($email['attachments'] as $file): ?>
                        <li>
                            <a href="<?= htmlspecialchars($file['path']) ?>" download>
                                <?= htmlspecialchars($file['name']) ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>

    <a class="edit-btn" href="edit.php?id=<?= urlencode($email['id']) ?>">
        Edit & Send Again
    </a>

    <?php if ($currentUser === 'admin'): ?>
        <a class="delete-btn"
           href="delete.php?id=<?= urlencode($email['id']) ?>"
           onclick="return confirm('Delete this email permanently?');">
            Delete
        </a>
    <?php endif; ?>
</div>
<?php endforeach; ?>

<!-- DESKTOP TABLE -->
<table>
<tr>
    <th>Date</th>
    <th>User</th>
    <th>From</th>
    <th>To</th>
    <th>Subject</th>
    <th>Actions</th>
</tr>

<?php foreach ($emails as $i => $email): ?>
<tr>
    <td><?= htmlspecialchars($email['date']) ?></td>
    <td><?= htmlspecialchars($email['user']) ?></td>
    <td><?= htmlspecialchars($email['from']) ?></td>
    <td><?= htmlspecialchars($email['to']) ?></td>
    <td><?= htmlspecialchars($email['subject']) ?></td>
    <td>
        <span class="toggle" onclick="toggleBody('d<?= $i ?>')">View</span> |
        <a class="edit-btn" href="edit.php?id=<?= urlencode($email['id']) ?>">Edit</a>
        <?php if ($currentUser === 'admin'): ?>
            | <a class="delete-btn"
                 href="delete.php?id=<?= urlencode($email['id']) ?>"
                 onclick="return confirm('Delete this email permanently?');">
                Delete
              </a>
        <?php endif; ?>
    </td>
</tr>
<tr>
    <td colspan="6">
        <div id="d<?= $i ?>" class="email-body">
            <?= $email['body'] ?>

            <?php if (!empty($email['attachments'])): ?>
                <div class="attachments">
                    <strong>Attachments:</strong>
                    <ul>
                        <?php foreach ($email['attachments'] as $file): ?>
                            <li>
                                <a href="<?= htmlspecialchars($file['path']) ?>" download>
                                    <?= htmlspecialchars($file['name']) ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </td>
</tr>
<?php endforeach; ?>
</table>

<!-- PAGINATION CONTROLS -->
<?php if ($totalPages > 1): ?>
<div style="margin-top:20px;text-align:center;">
    <?php if ($page > 1): ?>
        <a href="?page=<?= $page - 1 ?>">← Previous</a>
    <?php endif; ?>

    <strong style="margin:0 10px;">
        Page <?= $page ?> of <?= $totalPages ?>
    </strong>

    <?php if ($page < $totalPages): ?>
        <a href="?page=<?= $page + 1 ?>">Next →</a>
    <?php endif; ?>
</div>
<?php endif; ?>

</div>
</body>
</html>
